/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import java.util.Objects;

public class AlgorithmDescriptor
implements Comparable<AlgorithmDescriptor> {
    public final String family;
    public final String name;
    public final String version;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.family != null && this.family.length() > 0) {
            builder.append(this.family).append('/');
        }
        builder.append(this.name);
        if (this.version != null && this.version.length() > 0) {
            builder.append(" (").append(this.version).append(')');
        }
        return builder.toString();
    }

    public AlgorithmDescriptor(String family, String name, String version) {
        this.family = family;
        this.name = name;
        this.version = version;
    }

    public boolean match(String family, String name, String version) {
        if (family != null && !family.equalsIgnoreCase(this.family)) {
            return false;
        }
        if (!name.equalsIgnoreCase(this.name)) {
            return false;
        }
        return version == null || version.equalsIgnoreCase(this.version);
    }

    public boolean isCompatible(AlgorithmDescriptor information) {
        return this.match(information.family, information.name, information.version);
    }

    @Override
    public int compareTo(AlgorithmDescriptor o) {
        int cmp = this.family.compareToIgnoreCase(o.family);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareToIgnoreCase(o.name);
        if (cmp != 0) {
            return cmp;
        }
        if (this.version == null) {
            if (o.version == null) {
                return 0;
            }
            return -1;
        }
        if (o.version == null) {
            return 1;
        }
        return this.version.compareToIgnoreCase(o.version);
    }

    public boolean equals(Object o) {
        if (o instanceof AlgorithmDescriptor) {
            return this.compareTo((AlgorithmDescriptor)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.family.toLowerCase());
        hash = 83 * hash + Objects.hashCode(this.name.toLowerCase());
        return hash;
    }
}

