% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\docType{class}
\name{secrets}
\alias{secrets}
\title{Stored secrets in Key Vault}
\description{
This class represents the collection of secrets stored in a vault. It provides methods for managing secrets, including creating, importing and deleting secrets, and doing backups and restores.
}
\section{Methods}{

This class provides the following methods:

\if{html}{\out{<div class="sourceCode">}}\preformatted{create(name, value, content_type=NULL, attributes=vault_object_attrs(), ...)
get(name)
delete(name, confirm=TRUE)
list(include_managed=FALSE)
backup(name)
restore(backup)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the secret.
\item \code{value}: For \code{create}, the secret to store. This should be a character string or a raw vector.
\item \code{content_type}: For \code{create}, an optional content type of the secret, such as "application/octet-stream".
\item \code{attributes}: Optional attributes for the secret, such as the expiry date and activation date. A convenient way to provide this is via the \link{vault_object_attrs} helper function.
\item \code{...}: For \code{create}, other named arguments which will be treated as tags.
\item \code{include_managed}: For \code{list}, whether to include secrets that were created by Key Vault to support a managed certificate.
\item \code{backup}: For \code{restore}, a string representing the backup blob for a secret.
}
}

\section{Value}{

For \code{get}, and \code{create}, an object of class \code{stored_secret}, representing the secret. The actual value of the secret is in the \code{value} field.

For \code{list}, a vector of secret names.

For \code{backup}, a string representing the backup blob for a secret. If the secret has multiple versions, the blob will contain all versions.
}

\examples{
\dontrun{

vault <- key_vault("mykeyvault")

vault$secrets$create("mysecret", "secret string")

vault$secrets$list()

secret <- vault$secrets$get("mysecret")
secret$value  # 'secret string'

# specifying an expiry date
today <- Sys.date()
vault$secrets$create("mysecret", attributes=vault_object_attrs(expiry_date=today+365))

# setting management tags
vault$secrets$create("mysecret", tag1="a value", othertag="another value")

}
}
\seealso{
\link{vault_object_attrs}

\href{https://learn.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://learn.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
