% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage_accounts.R
\docType{class}
\name{storage_accounts}
\alias{storage_accounts}
\alias{storage}
\title{Storage accounts in Key Vault}
\description{
This class represents the collection of storage accounts managed by a vault. It provides methods for adding and removing accounts, and doing backups and restores. For operations with a specific account, see \link{storage}.
}
\section{Methods}{

This class provides the following methods:

\if{html}{\out{<div class="sourceCode">}}\preformatted{add(name, storage_account, key_name, regen_key=TRUE, regen_period=30,
    attributes=vault_object_attrs(), ...)
get(name)
remove(name, confirm=TRUE)
list()
backup(name)
restore(backup)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: A name by which to refer to the storage account.
\item \code{storage_account}: The Azure resource ID of the account. This can also be an object of class \code{az_resource} or \code{az_storage}, as provided by the AzureRMR or AzureStor packages respectively; in this case, the resource ID is obtained from the object.
\item \code{key_name}: The name of the storage access key that Key Vault will manage.
\item \code{regen_key}: Whether to automatically regenerate the access key at periodic intervals.
\item \code{regen_period}: How often to regenerate the access key. This can be a number, which will be interpreted as days; or as an ISO-8601 string denoting a duration, eg "P30D" (30 days).
\item \code{attributes}: Optional attributes for the secret. A convenient way to provide this is via the \link{vault_object_attrs} helper function.
\item \code{...}: For \code{create} and \code{import}, other named arguments which will be treated as tags.
\item \code{confirm}: For \code{remove}, whether to ask for confirmation before removing the account.
\item \code{backup}: For \code{restore}, a string representing the backup blob for a key.
\item \code{email}: For \code{set_contacts}, the email addresses of the contacts.
}
}

\section{Value}{

For \code{get} and \code{add}, an object of class \code{stored_account}, representing the storage account itself.

For \code{list}, a vector of account names.

For \code{backup}, a string representing the backup blob for a storage account. If the account has multiple versions, the blob will contain all versions.
}

\examples{
\dontrun{

vault <- key_vault("mykeyvault")

# get the storage account details
library(AzureStor)
stor <- AzureRMR::get_azure_login()$
    get_subscription("sub_id")$
    get_resource_group("rgname")$
    get_storage_account("mystorageacct")
vault$storage$create("mystor", stor, "key1")

vault$storage$list()
vault$storage$get("mystor")

# specifying a regeneration period of 6 months
vault$storage$create("mystor", regen_period="P6M")

# setting management tags
vault$storage$create("mystor", tag1="a value", othertag="another value")

# backup and restore an account
bak <- vault$storage$backup("mystor")
vault$storage$delete("mystor", confirm=FALSE)
vault$storage$restore(bak)

}
}
\seealso{
\link{storage_account}, \link{vault_object_attrs}

\href{https://learn.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://learn.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
