% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{stability_composite}
\alias{stability_composite}
\title{Composite stability score (numerical and temporal)}
\usage{
stability_composite(W, a = 1000, b = 10, kappa = 50)
}
\arguments{
\item{W}{Posterior matrix (\eqn{T \times K}).}

\item{a}{Sensitivity for row-sum deviation in numerical part (default \code{1000}).}

\item{b}{Sensitivity for negatives in numerical part (default \code{10}).}

\item{kappa}{Sensitivity for temporal smoothness (default \code{50}).}
}
\value{
Scalar composite stability score in \eqn{[0,1]}.
}
\description{
Convex combination of numerical and temporal stability:
\deqn{0.6 \cdot \mathrm{numerical\_stability\_exp}(W) + 0.4 \cdot \mathrm{temporal\_stability}(W).}
}
\examples{
W <- matrix(runif(20), 5); W <- W/rowSums(W)
stability_composite(W)

}
\seealso{
\code{\link{numerical_stability_exp}}, \code{\link{temporal_stability}}
}
