\name{DARWIN}
\docType{data}
\alias{DARWIN}
\title{DARWIN Handwriting Dataset (P vs H)}
\description{
Handwriting data from \strong{174} participants for a binary classification task:
distinguishing Alzheimer's disease patients (\code{P}) from healthy controls (\code{H}).
The feature matrix contains \strong{450} numeric handwriting-derived measures; the last
column \code{Y} is the class label with levels \code{P} and \code{H}.
}
\usage{
data(DARWIN)
}
\format{
A \code{data.frame} with \strong{174} rows and \strong{451} columns:
\describe{
  \item{Columns [1--450]}{Numeric handwriting features (predictors).}
  \item{\strong{\code{Y}}}{Factor, class label with two levels: \code{P} (patients), \code{H} (healthy).}
}
}
\details{
\itemize{
  \item \strong{Purpose:} Research on predicting Alzheimer's via handwriting analysis.
  \item \strong{Instances:} 174
  \item \strong{Features (X):} 450 (numeric)
  \item \strong{Target (Y):} \code{P}/\code{H}
  \item \strong{Missing values:} None
}
}
\source{
OpenML dataset ID 46606. \url{https://www.openml.org/search?type=data&status=any&id=46606&sort=runs}
}
\examples{
data(DARWIN)
dim(DARWIN)
table(DARWIN$Y)
}
