% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectCodelists.R
\name{intersectCodelists}
\alias{intersectCodelists}
\title{Generate a codelist from the intersection of different codelists. The generated
codelist will come out in alphabetical order.}
\usage{
intersectCodelists(x, keepOriginal = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
A codelist
}
\description{
Generate a codelist from the intersection of different codelists. The generated
codelist will come out in alphabetical order.
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create a CDM object
cdm <- mockCdmReference()

# Intersect two codelists
codelist <- newCodelist(list("mood" = c(37110496L, 4226696L, 4304866L),
                             "manic" = c(37110496L, 4226696L)))

intersectCodelists(codelist, keepOriginal = TRUE)


# Intersect two codelists_with_details
codelist <- asCodelistWithDetails(codelist, cdm)

intersectCodelists(codelist, keepOriginal = FALSE)
}
}
