% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bCond.tree.conversion.R
\name{conv_treeCKT}
\alias{conv_treeCKT}
\alias{treeCKT2matrixInd}
\alias{matrixInd2matrixCKT}
\alias{treeCKT2matrixCKT}
\title{Converting to matrix of indicators / matrix of conditional Kendall's tau}
\usage{
treeCKT2matrixInd(estimatedTree, newDataXJ = NULL)

matrixInd2matrixCKT(matrixInd, newDataXI)

treeCKT2matrixCKT(estimatedTree, newDataXI = NULL, newDataXJ = NULL)
}
\arguments{
\item{estimatedTree}{the tree that has been estimated before,
for example by \code{\link{bCond.treeCKT}}.}

\item{newDataXJ}{this is a matrix of size \code{N * |J|}
where \code{|J|} is the number of conditional variables used in the tree.
By default this is \code{NULL} meaning that
we return the matrix for the original data
(that was used to compute the \code{estimatedTree}).}

\item{matrixInd}{a matrix of indexes of size (n, N.boxes) describing
for each observation i to which box ( = event) it belongs.}

\item{newDataXI}{this is a matrix of size \code{N * |I|}
where \code{|I|} is the number of conditioned variables.
By default this is \code{NULL} meaning that
we return the matrix for the original data
used to compute the \code{estimatedTree}}
}
\value{
\itemize{
  \item The function \code{treeCKT2matrixInd} returns
  a matrix of size \code{N * m} which component \code{[i,j]}
  is \deqn{1\{ X_{i,J} \in A_{j,J} \}}.

  \item The function \code{matrixInd2matrixCKT} and \code{treeCKT2matrixCKT} return
  a matrix of size \code{|I| * (|I|-1) * m} where each component corresponds
  to a conditional Kendall's tau between a pair of conditional variables
  conditionally to the conditioned variables in one of the boxes
}
}
\description{
The function \code{treeCKT2matrixInd}
takes as input a binary tree that has been returned
by the function \code{\link{bCond.treeCKT}}.
Since this tree describes a partition of the conditioning space,
it can be interesting to get, for a given dataset, the matrix
\deqn{1\{ X_{i,J} \in A_{j,J} \},}
where each \eqn{A_{j,J}} corresponds to a conditioning subset.
This is the so-called \code{matrixInd}.
Finally, it can be interesting to get the matrix of
}
\examples{
set.seed(1)
n = 200
XJ = MASS::mvrnorm(n = n, mu = c(3,3), Sigma = rbind(c(1, 0.2), c(0.2, 1)))
XI = matrix(nrow = n, ncol = 2)
high_XJ1 = which(XJ[,1] > 4)
XI[high_XJ1, ]  = MASS::mvrnorm(n = length(high_XJ1), mu = c(10,10),
                                Sigma = rbind(c(1, 0.8), c(0.8, 1)))
XI[-high_XJ1, ] = MASS::mvrnorm(n = n - length(high_XJ1), mu = c(8,8),
                                Sigma = rbind(c(1, -0.2), c(-0.2, 1)))

result = bCond.treeCKT(XI = XI, XJ = XJ, minSize = 10, verbose = 2)

treeCKT2matrixInd(result)

matrixInd2matrixCKT(treeCKT2matrixInd(result), newDataXI = XI)

treeCKT2matrixCKT(result)

}
\seealso{
\code{\link{bCond.treeCKT}} for the construction of such a binary tree.
}
