% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shap_aggregated.R
\name{shap_aggregated}
\alias{shap_aggregated}
\title{SHAP aggregated values}
\usage{
shap_aggregated(
  explainer,
  new_observations,
  order = NULL,
  B = 25,
  kernelshap = FALSE,
  ...
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain} function}

\item{new_observations}{a set of new observations with columns that correspond to variables used in the model.}

\item{order}{if not \code{NULL}, then it will be a fixed order of variables. It can be a numeric vector or vector with names of variables.}

\item{B}{number of random paths; works only if kernelshap=FALSE}

\item{kernelshap}{indicates whether the kernelshap method should be used}

\item{...}{other parameters like \code{label}, \code{predict_function}, \code{data}, \code{x}}
}
\value{
an object of the \code{shap_aggregated} class.
}
\description{
This function works in a similar way to shap function from \code{iBreakDown} but it calculates explanations for a set of observation and then aggregates them.
}
\examples{
library("DALEX")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

\donttest{
bd_glm <- shap_aggregated(explain_titanic_glm, titanic_imputed[1:10, ])
bd_glm
plot(bd_glm, max_features = 3)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://ema.drwhy.ai}
}
