% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiScales.R
\docType{class}
\name{DexiDiscreteScale-class}
\alias{DexiDiscreteScale-class}
\alias{DexiDiscreteScale}
\title{DexiDiscreteScale}
\description{
\code{DexiDiscreteScale} is a RC class, derived from \link{DexiScale},
representing qualitative (symbolic, discrete, verbal) value scales in R. Such scales are
typical for DEXi models and are the only scale type supported by the DEXi software.
DEXiWin software supports both continuous and discrete scales.
}
\details{
An attribute associated with a discrete scale can take values from a finite (and usually small)
set of string values contained in the character vector \code{values}. Additionally, each of these values is
associated with one of the qualities \code{"bad"}, \code{"none"} or \code{"good"}.
The latter are contained in the character vector \code{quality},
which is of the same length as \code{values}.
}
\section{Fields}{

\describe{
\item{\code{values}}{character. Vector of qualitative scale values.
Example: \code{scale$values <- c("low", "medium", "high")}.}

\item{\code{nvals}}{integer. Equal to \code{length(values)}.}

\item{\code{quality}}{character. Vector of qualities, corresponding to \code{values}.
Should be the of the same length as \code{values}.
Example: \code{scale$quality <- c("bad", "none", "good")}.}

\item{\code{descriptions}}{character. A vector of textual descriptions of the corresponding
\code{values}. Should be of the same length as \code{values}.}
}}

\section{Methods}{

\describe{
\item{\code{count()}}{Return the number of scale elements.
Equal to \code{NA} for \code{DexiScale}, \code{0} for \code{DexiContinuousScale}, and
equal to \code{nvals >= 0} for \code{DexiDiscreteScale}.}

\item{\code{equal(scl)}}{Check if this scale is equal to scale \code{scl}. Needed for attribute linking.}

\item{\code{full_range()}}{Return the vector that represents the full range of values on this scale.
Equal to \code{NA} for \code{DexiScale} and \code{DexiContinuousScale},
and \code{1 : scale$nvals} for \code{DexiDiscreteScale}.}

\item{\code{initialize(order = EnumOrder, ...)}}{Initialize a \code{DexiScale} object.}

\item{\code{is_discrete()}}{Logical: Is this scale discrete?}

\item{\code{to_string()}}{Return a string representation of this scale for printing.}

\item{\code{value_index(value)}}{Find the index of \code{value} (character(1)) on this scale.
Equal to \code{NA} for \code{DexiScale} and \code{DexiContinuousScale}.
With \code{DexiDiscreteScale} objects, it returns a numeric index or \code{NA}
of \code{value} in \code{scale$values}.}

\item{\code{value_quality(value)}}{Return the quality (preferential class) of \code{value} on this scale:
one of the strings \code{"bad"}, \code{"none"} or \code{"good"}.
Always \code{"none"} for \code{DexiScale} and scales with \code{order = "none"}.}

\item{\code{verify()}}{Check the correctnes of this scale object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# For example, consider the scale of attribute PRICE
scl <- Car$attrib("PRICE")$scale

# Print fields and basic properties of scl
scl$verify()
scl$values
scl$quality
scl$descriptions
scl$nvals
scl$count()
scl$is_discrete()
scl$is_continuous()
scl$to_string()
scl$full_range()

# Find value indices
scl$value_index("medium")
scl$value_index("med")

# Is scl equal to the scale of BUY.PRICE?
scl$equal(Car$attrib("PRICE")$scale)

}
