% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{compare_values}
\alias{compare_values}
\title{compare_values}
\usage{
compare_values(value1, value2)
}
\arguments{
\item{value1}{First value.}

\item{value2}{Second value.}
}
\value{
\code{0} if values are equal, \code{-1} if \code{value1 < value2}, \code{+1} if \code{value1 > value2}
and \code{NA} if values are incomparable. Values are incomparable if they are of a non-DEXiValue
type or if they represent two overlapping sets.
}
\description{
Compare two DEXi values.
Internal representation is assumed for \code{value1} and \code{value2}, i.e.,
a single number, an integer vector representing a set or \code{\link[=distribution]{distribution()}}.
Distributions are compared as sets.
}
\examples{
compare_values(c(1,2), c(1,2))       # 0
compare_values(c(1,2), c(1,3))       # NA
compare_values(c(1,2), c(3,4))       # -1
compare_values(c(1,2), c(2,4))       # NA
compare_values(c(1,2), c(2.1,4))     # -1
compare_values(c(1,2.05), c(2.1,4))  # -1
compare_values(c(3,4), c(3,4))       # 0
compare_values(c(5,5), c(3,4))       # +1
compare_values(c(5,5), 2)            # +1
compare_values(c(5,2), 2)            # NA
compare_values(c(5,3), 2)            # +1
compare_values(distribution(5,3), 2) # NA
compare_values(distribution(5,3), 5) # -1
}
