% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{value_text}
\alias{value_text}
\title{value_text}
\usage{
value_text(value, scale, round = NULL)
}
\arguments{
\item{value}{Any DEXi value type (see \link{DEXiR-package}).}

\item{scale}{A \link{DexiScale} or derived object.}

\item{round}{An integer number. Indicates the number of decimals for
rounding numeric values prior to printing. If \code{NULL}, no rounding takes place.}
}
\value{
character.
}
\description{
Converts a DEXi \code{value} to a human-readable character string that can be printed.
Used, for instance, by \code{DexiModel$as_character()}.
}
\examples{
scl <- DexiDiscreteScale(values = c("low", "med", "high"))
value_text(NA, scl)
value_text(1, scl)
value_text(c(1, 3), scl)
value_text(distribution(0.1, 0.2, 0.3), scl)

}
