% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_sources.R
\name{list_data_sources}
\alias{list_data_sources}
\title{List data sources}
\usage{
list_data_sources(packageId, as = "data.frame", env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Data sources to \code{packageId}
}
\description{
Data sources are data packages, or other online digital
objects, that are known to be inputs to the specified derived data package.
}
\details{
Data sources can be either internal or external to the EDI data
repository. Internal data sources include a packageId value and a URL to the
source metadata. For data sources external to PASTA, the packageId element
will be empty and a URL value may or not be documented.
}
\examples{
\dontrun{

# List sources
dataSources <- list_data_sources("edi.275.4")
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
