% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_user_data_packages.R
\name{list_user_data_packages}
\alias{list_user_data_packages}
\title{List user data packages}
\usage{
list_user_data_packages(dn, env = "production")
}
\arguments{
\item{dn}{(character) Distinguished name of user. Create with
\code{create_dn()}.}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) Data package identifiers belonging to a \code{dn}
}
\description{
List all data packages (including their revision values)
uploaded to the repository by a particular user, specified by a
distinguished name. Data packages that were uploaded by the specified user
but have since been deleted are excluded from the list.
}
\examples{
\dontrun{

# List user data packages
dn <- create_dn(userId = "dbjourneynorth")
packageIds <- list_user_data_packages(dn)
packageIds
#> [1] "edi.948.1" "edi.949.1"
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()}
}
\concept{Listing}
