% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_loadings.R
\name{compute_loadings}
\alias{compute_loadings}
\title{Compute Loadings}
\usage{
compute_loadings(data, num_blocks, ranges, r_list, factor_list, loadings_list)
}
\arguments{
\item{data}{A numeric matrix or data frame containing the time series data (T × N).}

\item{num_blocks}{Integer. Number of blocks.}

\item{ranges}{A list of vectors with the column indices for each block.}

\item{r_list}{A named list specifying the number of factors to extract for each node (from \code{build_factor_structure}).}

\item{factor_list}{A named list of factors extracted at each node (from \code{compute_initial_factors}).}

\item{loadings_list}{A named list to which updated loadings will be appended for each node.}
}
\value{
A list with:
\describe{
\item{loadings}{A numeric matrix (total factors × total variables) with estimated loadings.}
\item{loadings_list}{An updated named list of loadings for each node.}
}
}
\description{
Computes the full loadings matrix for the Multi-Level Dynamic Factor Model.
}
\keyword{internal}
