% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.krr}
\alias{plot.krr}
\title{Plot method for fitted Kernel Ridge Regression (KRR) models}
\usage{
\method{plot}{krr}(x, show_points = TRUE, ...)
}
\arguments{
\item{x}{A fitted KRR model (class \code{"krr"}) returned by \code{\link{fastkrr}}.}

\item{show_points}{Logical; if \code{TRUE}, displays the training data points.
Default = \code{TRUE}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A ggplot object showing the fitted regression curve.
}
\description{
Visualizes fitted results from a Kernel Ridge Regression (KRR) model.
Automatically generates predictions on a regular grid
(120\% of training sample size) and overlays them with training data.
}
\details{
For multivariate inputs (\eqn{d \ge 2}), visualization requires fixing
all but one variable. For example, in 2D, one can plot
\eqn{f(x_1, x_2 = \bar{x}_2)} to examine the effect of \eqn{x_1}
while holding \eqn{x_2} at its mean.
}
\examples{
\donttest{
set.seed(1)
n = 1000
rho = 1
X = runif(n, 0, 1)
y = sin(2*pi*X^3) + rnorm(n, 0, 0.1)

model_exact = fastkrr(X, y, kernel = "gaussian", rho = rho, opt = "exact", verbose = FALSE)
plot(model_exact)
}

}
\seealso{
\code{\link{fastkrr}}, \code{\link{predict.krr}}
}
