% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DenseGRM.R
\name{setDenseGRM}
\alias{setDenseGRM}
\title{Set up a dense GRM (only for developers)}
\usage{
setDenseGRM(GenoFile, GenoFileIndex = NULL, subjData = NULL)
}
\arguments{
\item{GenoFile}{a character of genotype file. Three types of genotype files are supported: PLINK ("prefix.bed"), BGEN ("prefix.bgen"), and VCF ("prefix.vcf" or "prefix.vcf.gz").}

\item{GenoFileIndex}{additional index files corresponding to the "GenoFile". If Null (default), the same prefix as GenoFile is used. PLINK: c("prefix.bim", "prefix.fam"), BGEN: c("prefix.bgi"), and VCF: c("prefix.vcf.tbi") or c("prefix.vcf.gz.tbi").}

\item{subjData}{a character vector of subject IDs. Its order should be the same as the subjects order in the formula and data.}
}
\value{
no result is returned
}
\description{
Set up a dense GRM (only for developers), other users can ignore this function
}
\examples{
# Check ?getDenseGRM() for an example.

}
