% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding-objects.R
\name{author_last_comment}
\alias{author_last_comment}
\alias{author_last_comment.IssueTB}
\alias{author_last_comment.IssuesTB}
\title{Name of last commentator}
\usage{
author_last_comment(x)

\method{author_last_comment}{IssueTB}(x)

\method{author_last_comment}{IssuesTB}(x)
}
\arguments{
\item{x}{An object of class \code{IssueTB} or \code{IssuesTB}.}
}
\value{
A string with the name of the last person which leaves a comment.
If there is no comments, it returns an empty string.
}
\description{
Retrieve the name of the last commentator
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "open_issues.yaml"
)
author_last_comment(all_issues)
author_last_comment(all_issues[1L, ])

}
