% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{data}
\name{method_registry}
\alias{method_registry}
\title{Registry of Available Life Expectancy Decomposition Methods}
\format{
A data frame with 28 rows and 3 variables:
\describe{
\item{method}{Character. The method name used in the \code{method} argument of \code{LEdecomp()}.}
\item{fun_name}{Character. The actual function name (as a string) used to compute the decomposition.}
\item{category}{Character. One of \code{"direct"}, \code{"direct_sen"}, \code{"opt_ok"}, or \code{"general"}, indicating how the method operates internally:
\itemize{
\item \code{"direct"}: Classic decomposition methods using two full input vectors (e.g., Arriaga, Lopez-Ruzicka).
\item \code{"direct_sen"}: Sensitivity-based methods that take \code{mx1} and \code{mx2}, and divide the result by their difference.
\item \code{"opt_ok"}: Sensitivity methods that accept a single \code{mx} input and optionally allow optimization over the interpolation point between \code{mx1} and \code{mx2}.
\item \code{"general"}: Generic methods like \code{stepwise} and \code{horiuchi} using externally provided tools (e.g., from DemoDecomp).
}
}
\item{pkg}{Character. The package where the underlying decomp function resides.}
}
}
\usage{
method_registry
}
\description{
A reference table listing all decomposition methods implemented in the \code{LEdecomp} package,
along with their corresponding function names and classification.
}
\details{
This registry helps centralize method metadata and supports internal operations
like method matching, class-based routing, and printing.
}
\seealso{
\code{\link{available_methods}}, \code{\link{LEdecomp}}
}
\keyword{datasets}
\keyword{internal}
