% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{sen_lopez_ruzicka}
\alias{sen_lopez_ruzicka}
\title{Sensitivity from Lopez-Ruzicka decomposition}
\usage{
sen_lopez_ruzicka(
  mx1,
  mx2,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
A numeric vector of sensitivity values by age group.
}
\description{
Computes the sensitivity of life expectancy to changes in age-specific mortality rates using the Lopez-Ruzicka decomposition approach. The sensitivity is calculated by dividing the age-specific contributions (from \code{lopez_ruzicka()}) by the differences in mortality rates (\code{mx2 - mx1}). This gives a pointwise estimate of the derivative of life expectancy with respect to each age-specific mortality rate, evaluated at an imagined midpoint between the two input rate schedules.
}
\details{
This method gives numerically identical results to \code{sen_arriaga()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a / 2 * exp(x * b)
s <- sen_lopez_ruzicka(mx1, mx2, age = x)

# Check that multiplying sensitivity by rate difference reproduces the decomposition
cc_check <- s * (mx2 - mx1)
cc <- lopez_ruzicka(mx1, mx2, age = x)
\donttest{
plot(x, cc, type = "l")
lines(x, cc_check, col = "red", lty = 2)
}

}
\references{
\insertRef{Ponnapalli2005}{LEdecomp}
}
\seealso{
\code{\link{lopez_ruzicka}}, \code{\link{sen_arriaga}}, \code{\link{sen_chandrasekaran_III}}
}
