% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_detection_functions.R
\name{find_loops_noscc}
\alias{find_loops_noscc}
\title{Loop detection in a matrix}
\usage{
find_loops_noscc(jacobian, max_num_loops = 1e+05)
}
\arguments{
\item{jacobian}{Square Jacobian matrix of an ODE system or the adjacency
matrix of a graph; captures interactions such that entry \code{(i,j)} is
negative (positive) if variable \code{j} regulates variable \code{i}
negatively (positively).}

\item{max_num_loops}{Positive numeric value indicating the maximal number
of loops that are reported. Default: \eqn{10^5}.}
}
\value{
A data.frame with three columns: \code{loop}, \code{length}, \code{sign}
 containing up to \code{max_num_loops} loops of the systems defined
 by matrix \code{jacobian}. Each entry in the loop column is a list of
 identifiers that correspond to the indices of the variable in the
 Jacobian matrix and denote
 in which order the variables form the loop.
}
\description{
Given the Jacobian matrix of an ODE system or the adjacency
 matrix of a graph, this function determines all loops in the system up
 to the maximal number supplied. No
 decomposition into strongly connected components is performed.
}
\details{
The input matrix delivers the directed interactions in the ODE
 system; if entry \code{(i,j)} is non-zero it means that variable (or
 node) \code{i} is regulated by variable (node) \code{j}. Johnson's
 algorithm for path detections
 from the igraph package (function:
 \code{\link[igraph]{all_simple_paths}}) is used.
 No decomposition into strongly connected components is employed which
 could be beneficial for smaller systems (compared to
 \code{\link{find_loops}}).
 The queried graph is increased stepwise leading to the output of loops
 in a certain order determined by the order of occurrence in the Jacobian
 matrix:
 \itemize{
 \item first the self-loops,
 \item then feedback loops incorporating only the first and second species of
 the Jacobian,
 \item then feedback loops incorporating the third and at most also the first
 and second species of the jacobian, etc.}
 If the maximal number of loops, max_num_loops, is reached, no warning is
 issued. It is very probable that not all feedback loops of the system
 have been found.
 Up to which species this function searched before stopping due to
 reaching the maximal allowed loop number can be inferred from the last
 exported feedback loop.
 Running the function multiple times with re-ordered jacobian as input
 can enable detection of alternative feedback loops while limiting the
 runtime and output size of single runs.
 If columns of the Jacobian are named,
 the identification is given by the attribute \code{node_ids},
 \code{attr(result,"node_ids")}.
}
\examples{
#sample Jacobian matrix of a system with 4 variables
jac_matrix <- rbind(c(-1,0,0,-1),c(1,-1,0,1),c(0,1,-1,0),c(0,0,1,-1))
#find the first 5 feedback loops of the system
loop_list <- find_loops_noscc(jac_matrix,5)

}
\seealso{
\code{\link{find_loops}},  \code{\link{find_loops_vset}}
}
