colcens.mle <- function(x, distr = "censweibull", di, tol = 1e-07, parallel = FALSE, cores = 0) {
  if ( distr == "censweibull" ) {
    res <- Rfast2::colcensweibull.mle(x, di, tol = tol, parallel = parallel, cores = cores)
  } else if ( distr == "censpois" ) {
    res <- Rfast2::colcenspois.mle(x, tol = tol, parallel = parallel, cores = cores)
  } else if ( distr == 'tobit'){
    res <- .coltobit.mle(x, tol = tol)
  }
  res
}



#--------coltobit.mle--------------------------------
.coltobit.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::tobit.mle(x, tol) )
  colnames(res) <- c('iters', 'loglik', 'location', 'scale')
  res
}
