% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMeasurementValueAsNumeric.R
\name{tableMeasurementValueAsNumber}
\alias{tableMeasurementValueAsNumber}
\title{Format a measurement_summary object into a visual table}
\usage{
tableMeasurementValueAsNumber(
  result,
  header = c(visOmopResults::strataColumns(result)),
  groupColumn = c("codelist_name"),
  settingsColumn = character(),
  hide = c("variable_name", "variable_level"),
  style = NULL,
  type = NULL,
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
`visOmopResults::tableColumns(result)`.}

\item{groupColumn}{Columns to group by. See options with
`visOmopResults::tableColumns(result)`.}

\item{settingsColumn}{Columns from settings to include in results. See
options with `visOmopResults::settingsColumns(result)`.}

\item{hide}{Columns to hide from the visualisation. See options with
`visOmopResults::tableColumns(result)`.}

\item{style}{Named list that specifies how to style the different parts of
the table generated. It can either be a pre-defined style ("default" or
"darwin" - the latter just for gt and flextable), or NULL which converts to
"default" style, or custom code.}

\item{type}{Type of table. Check supported types with
`visOmopResults::tableType()`. If NULL 'gt' type will be used.}

\item{.options}{A named list with additional formatting options.
`visOmopResults::tableOptions()` shows allowed arguments and their default values.}
}
\value{
A formatted table
}
\description{
Format a measurement_summary object into a visual table
}
\examples{
\donttest{
library(MeasurementDiagnostics)

cdm <- mockMeasurementDiagnostics()

result <- summariseMeasurementUse(
  cdm = cdm,
  codes = list("test_codelist" = c(3001467L, 45875977L))
)

tableMeasurementValueAsNumber(result)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
