% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intern_herbicide.R
\name{intern_herbicide}
\alias{intern_herbicide}
\title{Surviving the Herbicide}
\usage{
intern_herbicide(resist, n_samples, put, rate, sdrate, thresh)
}
\arguments{
\item{resist}{numeric, value of resistance for the genotype (defined by Renton et al. 2011). Shall be \eqn{\le 1}.}

\item{n_samples}{integer, the number of weeds with one specific genotype.}

\item{put}{probability of a weed to be untouched by the herbicide. \code{numeric}, \eqn{0 \le \code{put} \le 1}.}

\item{rate}{percentage (\%) of the registered herbicide dose. \code{positive numeric}, can exceed 100 \%.}

\item{sdrate}{variance of the herbicide rate reaching the weed. \code{positive numeric}, 1 = 1 unit standard deviation.}

\item{thresh}{threshold herbicide rate to kill weeds without resistance. \code{numeric}, \eqn{0 \le \code{thresh} \le 1}.}
}
\value{
The number of weeds surviving the herbicide.
}
\description{
Utility function internally used. It's used only by \code{sel_herb}, and usually there is no reason to change it. Calculates the surviving number of weeds according to the specific genotype.
}
\details{
\code{intern_herbicide} is used in \code{\link{sel_herb}}. Firstly, it calculates the number of weeds that are untouched by the herbicide by chance (probability=\code{put}). In the second step, the herbicide rate that reached an individual is compared with the resistance value (calculated after Renton et al. 2011, \code{\link{sel_resist}}). If the resistance value is lower than the dose, the weed dies. All surviving weeds are summed up.
}
\examples{
#How many of 1000 weeds of a genotype with resistance value 5.5 survive a herbicide application 
#with full dose? 'It is assumed that weeds reseaving less than 20 \\% of the full dose survive
#independently of their resistant value.
intern_herbicide(resist=5.5, n_samples=1000, put=0.04, rate=100, sdrate=0.4, thresh=20)
}
\references{
Renton, M.; Diggle, A.; Manalil, S. & Powles, S. (2011): Does cutting herbicide rates threaten the sustainability of weed management in cropping systems? Journal of Theoretical Biology, 283, 14-27.
}
\seealso{
\code{\link{sel_herb}} \code{\link{sel_resist}}
}
