% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null.all.r
\name{null.all}
\alias{null.all}
\title{Checks for the presence of and determine the frequency of null alleles}
\usage{
null.all(population)
}
\arguments{
\item{population}{a \code{\link[adegenet]{genind}} object (from the package adegenet)}
}
\value{
The function returns a list with two main components: homozygotes
and null.allele.freq.  Homozygotes contains the output of the first part of
the analysis: determining the observed number of homozygotes for allele at
each locus (homozygotes$observed), generating a distribution of the expected
number of homozygotes for each allele at each locus (homozygotes$bootstrap)
based upond the observed allele frequencies at a locus, and producing a
summary table given the probability of observing the number of homozygotes
(homozygotes$probability.obs).  null.allele.freq list contains summary
tables of the null allele frequency estimates based upon the forumulas of
Chakraborty et al. (1994) (summary1), and Brookfield (1996) (summary2). For
each summary table, the observed frequency is the null allele frequency
determined from the observed heterozygosity and homozygosity at a locus. The
median, 2.5th, and 97.5th percentiles are from bootstrap estimates of null
allele frequencies obtained by resampling the individual genotypes from the
original genind object.

Brookfield (1996) provides a brief discussion on which estimator should be
used. In summary, it was recommended that Chakraborty et al. (1994)'s method
(e.g. summary1) be used if there are individuals with no bands at a locus
seen, but they are discounted as possible artefacts. If all individuals have
one or more bands at a locus then Brookfield (1996)'s method (e.g. summary2)
should be used.
}
\description{
The function null.all determines the frequency of null alleles at each locus
of a genind object. As an initial step, the function makes a bootstrap
estimate (based on the observed allele frequencies) of the probability of
seeing the number of homozygotes observed for each allele. If there are a
large number of null alleles present at a locus, it would result in multiple
alleles at a locus having an excess of homozygotes. The second step of the
function estimates the frequency of null alleles and a bootstrap confidence
interval for each locus using the methods of Chakraborty et al. (1994) and
Brookfield (1996). If the 95\% confidence interval includes zero, it
indicates that the frequency of null alleles at a locus does not
significantly differ from zero.
}
\examples{

 \dontrun{
 data(bilby)
 #here we use only the first 50 individuals to speep up the example
 popgenreport(bilby, mk.null.all=TRUE, mk.pdf=FALSE)
 
#to get a pdf output you need to have a running Latex version installed on your system.
#popgenreport(bilby, mk.null.all=TRUE, mk.pdf=TRUE)
}
}
\references{
Brookfield JFY. (1996) A simple new method for estimating null
allele frequency from heterozygote deficiency. Molecular Ecology 5:453-455

Chakraborty R, Zhong Y, Jin L, Budowle B. (1994) Nondetectability of
restriction fragments and independence of DNA fragment sizes within and
between loci in RFLP typing of DNA. American Journal of Human Genetics
55:391-401
}
\seealso{
\code{\link{popgenreport}}
}
\author{
Aaron Adamack, aaron.adamack@canberra.edu.au
}
