% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_rolling_correlation}
\alias{calc_rolling_correlation}
\title{Rolling correlation of each symbol to a benchmark}
\usage{
calc_rolling_correlation(
  data,
  benchmark_symbol = "SPY",
  lookback = 60,
  min_periods = NULL,
  method = c("pearson", "spearman")
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table} with a \code{Date} column and one
column per symbol containing prices. Must include \code{benchmark_symbol}.}

\item{benchmark_symbol}{Character, the benchmark column name (default \code{"SPY"}).}

\item{lookback}{Integer window size (>= 2) for rolling correlations.}

\item{min_periods}{Minimum number of valid observations within the window
to compute a correlation. Default is \code{ceiling(lookback * 0.67)}.}

\item{method}{Correlation method, \code{"pearson"} (default) or \code{"spearman"}.}
}
\value{
A \code{data.table} with \code{Date} and one column per non-benchmark symbol,
containing rolling correlations. Insufficient data yields \code{NA}s.
}
\description{
Computes rolling correlations between each symbol and a benchmark series
(e.g., \code{SPY}) using simple returns over a fixed lookback window.
}
\details{
Returns are computed as simple returns \eqn{(P_t - P_{t-1})/P_{t-1}}.
Windows with fewer than \code{min_periods} valid pairs are marked \code{NA}.
}
\examples{
data(sample_prices_weekly)
corr <- calc_rolling_correlation(
  data = sample_prices_weekly,
  benchmark_symbol = "SPY",
  lookback = 20
)
head(corr)

}
\seealso{
\code{\link[=calc_momentum]{calc_momentum()}}, \code{\link[=calc_rolling_volatility]{calc_rolling_volatility()}}
}
