% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_plot_ic_roll}
\alias{ml_plot_ic_roll}
\title{Rolling rank-IC plot (rebalance dates; leakage-safe)}
\usage{
ml_plot_ic_roll(scores_dt, labels_dt, window = 26L, method = "spearman")
}
\arguments{
\item{scores_dt}{Scores (wide).}

\item{labels_dt}{Labels (wide).}

\item{window}{Integer window length (default 26).}

\item{method}{Correlation method; \code{"spearman"} (default) or \code{"pearson"}.}
}
\value{
(Invisibly) a data frame with \code{Date}, \code{roll_mean}, \code{roll_sd}, \code{roll_ICIR}.
}
\description{
Computes the IC time series via \code{\link[=ml_ic_series_on_scores]{ml_ic_series_on_scores()}} and plots the
rolling mean IC over a specified window. Returns the rolling statistics
invisibly for further inspection.
}
\examples{
\dontrun{
ris <- ml_plot_ic_roll(res_xgb$scores, Y, window = 8L)
}
}
