% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{roll_ic_stats}
\alias{roll_ic_stats}
\title{Rolling IC mean, standard deviation, and ICIR}
\usage{
roll_ic_stats(ic_dt, window = 26L)
}
\arguments{
\item{ic_dt}{Data frame/data.table produced by \code{\link{ic_series}} with columns \code{Date} and \code{IC}.}

\item{window}{Integer window length for the rolling statistics.}
}
\value{
A \code{data.table} with columns \code{Date}, \code{IC_mean}, \code{IC_sd}, and \code{ICIR}.
}
\description{
Compute rolling information coefficient (IC) statistics from a per-date IC series.
}
\details{
For each rolling window, compute the mean IC, the standard deviation of IC,
and the information coefficient ratio (ICIR = mean / sd). Windows with fewer
than two finite IC values yield \code{NA} for ICIR.
}
