% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tz_malaria.R
\docType{data}
\name{tz_malaria}
\alias{tz_malaria}
\title{Malaria Dataset from Tanzania Demographic Health Surveys 2015}
\format{
A data frame with 387 rows and 20 columns, containing the following variables:
The CRS of the UTM coordinates is 32736.
}
\source{
\href{https://dhsprogram.com}{Tanzania Demographic Health Surveys 2015},
Giorgi E, Fronterrè C, Macharia PM, Alegana VA, Snow RW, Diggle PJ. (2021)
Model building and assessment of the impact of covariates for disease prevalence
mapping in low-resource settings: to explain and to predict.
J. R. Soc. Interface 18: 20210104. \doi{10.1098/rsif.2021.0104}
}
\usage{
data(tz_malaria)
}
\description{
This dataset contains information on malaria prevalence and associated variables from the 2015 Tanzania Demographic Health Surveys. The data includes geographical, demographic, environmental, and health-related variables.

\describe{
  \item{cluster.number}{ Cluster number, identifying the survey cluster.}
  \item{Lat}{ Latitude of the survey cluster.}
  \item{Long}{ Longitude of the survey cluster.}
  \item{MM}{ Month of the survey (in two-digit format).}
  \item{YY}{ Year of the survey.}
  \item{UpAge}{ Upper age limit of the surveyed individuals in years.}
  \item{LoAge}{ Lower age limit of the surveyed individuals in years.}
  \item{Ex}{ Number of individuals examined for malaria.}
  \item{Pf}{ Number of individuals tested positive for Plasmodium falciparum (malaria parasite).}
  \item{PfPR2.10}{ Plasmodium falciparum parasite rate in the population (aged 2-10 years).}
  \item{Method}{ Method used for malaria diagnosis (e.g., Rapid Diagnostic Test (RDT)).}
  \item{EVI}{ Enhanced Vegetation Index, indicating vegetation density.}
  \item{Temperature}{ Average temperature in degrees Celsius.}
  \item{Precipitation}{ Total precipitation in millimeters.}
  \item{Population}{ Population density in the area (in thousands).}
  \item{ITN}{ Percentage of households with at least one insecticide-treated net (ITN).}
  \item{NTL}{ Nighttime light intensity, indicating urbanization and infrastructure.}
  \item{Urban.Rural}{ Indicator of whether the area is urban ('U') or rural ('R').}
  \item{utm_x}{ UTM (Universal Transverse Mercator) x-coordinate of the survey cluster.}
  \item{utm_y}{ UTM (Universal Transverse Mercator) y-coordinate of the survey cluster.}
}
}
\keyword{datasets}
