% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCB_gls_geospatial.R
\name{MB_}
\alias{MB_}
\title{Multiplier Bootstrap for Simultaneous Confidence Band Threshold}
\usage{
MB_(x, y, R, N = 1000)
}
\arguments{
\item{x}{A numeric vector of x-coordinates.}

\item{y}{A numeric vector of y-coordinates.}

\item{R}{A 3D array of standardized residuals with dimensions \code{[length(x), length(y), n]}, where \code{n} is the sample size.}

\item{N}{An integer specifying the number of bootstrap samples. Default is \code{1000}.}
}
\value{
A numeric vector of length \code{N}, containing the maximum standardized deviation across all spatial locations for each bootstrap sample.
These can be used to compute the \code{(1 - alpha)} quantile as the SCB threshold.
}
\description{
Internal function used to compute the threshold value for constructing simultaneous confidence bands via multiplier bootstrap.
}
\examples{
# Used internally by SCB_gls_geospatial

}
\keyword{internal}
