% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform.R
\name{uniform.optim}
\alias{uniform.optim}
\title{Optimize a design based on the wrap-around discrepancy}
\usage{
uniform.optim(D.ini, iteration = 10)
}
\arguments{
\item{D.ini}{the initial design.}

\item{iteration}{number iterations for LBFGS.}
}
\value{
\item{design}{optimized design.}
\item{D.ini}{initial design.}
}
\description{
This function optimizes a design through continuous optimization of the wrap-around discrepancy.
}
\details{
\code{uniform.optim} optimizes a design through continuous optimization of the wrap-around discrepancy (see \code{\link{uniform.crit}}) by L-BFGS-B algorithm (Liu and Nocedal 1989).
}
\examples{
n = 20
p = 3
D = uniformLHD(n, p)$design
D = uniform.optim(D)$design

}
\references{
Liu, D. C., & Nocedal, J. (1989). On the limited memory BFGS method for large scale optimization. Mathematical programming, 45(1), 503-528.
}
