% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.tridim_transformation}
\alias{predict.tridim_transformation}
\title{Computes posterior samples for the posterior predictive distribution.}
\usage{
\method{predict}{tridim_transformation}(object, newdata = NULL, summary = TRUE, probs = NULL, ...)
}
\arguments{
\item{object}{An object of class \link[=tridim_transformation-class]{tridim_transformation}}

\item{newdata}{An optional two column data frame with independent variables.
If omitted, the fitted values are used.}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to NULL (no CI).}

\item{...}{Unused}
}
\value{
If summary=FALSE, a numeric matrix iterationsN x observationsN x variablesN.
If summary=TRUE, a data.frame with columns with mean for each dependent
variable plus optional quantiles columns.
}
\description{
Predicted values based on the bi/tridimensional regression model object.
}
\examples{
euc2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
  NakayaData, transformation = 'euclidean')

# prediction summary
predictions <- predict(euc2)

# full posterior prediction samples
predictions <- predict(euc2, summary=FALSE)
}
\seealso{
\code{\link{fit_transformation}}
}
