% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2rm__main.R
\name{plot.TwoRegression}
\alias{plot.TwoRegression}
\title{Create summary plots for TwoRegression objects}
\usage{
\method{plot}{TwoRegression}(
  x = NULL,
  object = NULL,
  sed_cp_activities,
  sed_activities,
  sed_cpVar = NULL,
  activity_var,
  met_var,
  walkrun_activities,
  walkrun_cpVar,
  x_sed = NULL,
  y_sed = NULL,
  x_walkrun = NULL,
  y_walkrun = NULL,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{passed from generic function but not used in the method}

\item{object}{the TwoRegression object}

\item{sed_cp_activities}{Character vector. Activities to be included in the
process of forming the sedentary classifier}

\item{sed_activities}{Character vector. Actual sedentary activities}

\item{sed_cpVar}{character scalar. The name of the variable on which the
cut-point is based}

\item{activity_var}{Character scalar. Name of the variable defining which
activity is being performed}

\item{met_var}{character scalar. The name of the variable containing energy
expenditure values, in metabolic equivalents}

\item{walkrun_activities}{Character vector. Actual ambulatory activities}

\item{walkrun_cpVar}{character scalar giving the name of the variable on
which the walk/run cut-point is based}

\item{x_sed}{numeric scalar giving x coordinate for label placement in
sedentary cut-point plot}

\item{y_sed}{numeric scalar giving y coordinate for label placement in
sedentary cut-point plot}

\item{x_walkrun}{numeric scalar giving x coordinate for label placement in
walk/run cut-point plot}

\item{y_walkrun}{numeric scalar giving y coordinate for label placement in
walk/run cut-point plot}

\item{print}{logical. Should the plot be arranged in a grid? If false, the
panels will be returned in a list of \code{gg/ggplot} objects.}

\item{...}{further arguments passed to plotting calls}
}
\value{
A two-by-two grid of summary plots
}
\description{
Four plots are generated: a threshold plot for both cut-points, and a model
plot for both regression models
}
\examples{
data(all_data, package = "TwoRegression")
all_data$PID <-
  rep(
    c("Test1", "Test2"),
    each = ceiling(nrow(all_data) / 2))[seq(nrow(all_data))]

fake_sed <- c("Lying", "Sitting")
fake_lpa <- c("Sweeping", "Dusting")
fake_cwr <- c("Walking", "Running")
fake_ila <- c("Tennis", "Basketball")

fake_activities <- c(fake_sed, fake_lpa, fake_cwr, fake_ila)

all_data$Activity <-
  sample(fake_activities, nrow(all_data), TRUE)

all_data$fake_METs <-
  ifelse(all_data$Activity \%in\% c(fake_sed, fake_lpa),
    runif(nrow(all_data), 1, 2),
    runif(nrow(all_data), 2.5, 8)
  )

ex_2rm <- fit_2rm(
  data = all_data,
  activity_var = "Activity",
  sed_cp_activities = c(fake_sed, fake_lpa),
  sed_activities = fake_sed,
  sed_cp_var = "ENMO",
  sed_METs = 1.25,
  walkrun_activities = fake_cwr,
  walkrun_cp_var = "ENMO_CV10s",
  met_var = "fake_METs",
  walkrun_formula = "fake_METs ~ ENMO",
  intermittent_formula = "fake_METs ~ ENMO + I(ENMO^2) + I(ENMO^3)"
)

model_plot_list <- plot(
  object = ex_2rm,
  sed_cp_activities = c(fake_sed, fake_lpa),
  sed_activities = fake_sed,
  sed_cpVar = "ENMO",
  activity_var = "Activity",
  met_var = "fake_METs",
  walkrun_activities = fake_cwr,
  walkrun_cpVar = "ENMO_CV10s",
  print = FALSE
)

\donttest{
  print(model_plot_list$sed_cut_point)
  print(model_plot_list$walkrun_cut_point)
  print(model_plot_list$walkrun_regression)
  print(model_plot_list$intermittent_regression)

  plot(
    object = ex_2rm,
    sed_cp_activities = c(fake_sed, fake_lpa),
    sed_activities = fake_sed,
    sed_cpVar = "ENMO",
    activity_var = "Activity",
    met_var = "fake_METs",
    walkrun_activities = fake_cwr,
    walkrun_cpVar = "ENMO_CV10s",
    print = TRUE
  )
}
}
