% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.regression}
\alias{wp.regression}
\title{Statistical Power Analysis for Linear Regression}
\usage{
wp.regression(n = NULL, p1 = NULL, p2 = 0, f2 = NULL, alpha = 0.05,
  power = NULL, type=c("regular", "Cohen"))
}
\arguments{
\item{n}{Sample size.}

\item{p1}{Number of predictors in the full model.}

\item{p2}{Number of predictors in the reduced moedel, it is 0 by default. See the book by \cite{Maxwell and Delaney (2003)} for the definition of the reduced model.}

\item{f2}{Effect size.
We use the statistic f2 as the measure of effect size for linear regression proposed by \cite{Cohen(1988, p.410)}.
\cite{Cohen} discussed the effect size in three different cases.
The calculation of f2 can be generalized using the idea of a full model and a reduced model by \cite{Maxwell and Delaney (2003)}.}

\item{alpha}{significance level chosen for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}
\item{type}{If set to "Cohen", the formula used in the Cohen's book will be used (not recommended).}
}
\value{
An object of the power analysis
}
\description{
This function is for power analysis for regression models. Regression is a statistical technique for examining the relationship between one or more independent variables (or predictors) and one dependent variable (or the outcome).
Regression provides an F-statistic that can be formulated using the ratio between variation in the outcome variable that is explained by the predictors and the unexplained variation \cite{(Cohen, 1988))}.
The test statistc can also be experessed in terms of caomparison between Full and Reduced models \cite{(Maxwell & Delaney, 2003)}.
}
\examples{
#To calculate the statistical power given sample size and effect size:
wp.regression(n = 100, p1 = 3, f2 = 0.1, alpha = 0.05, power = NULL)
#  Power for multiple regression
#
#      n p1 p2  f2 alpha     power
#    100  3  0 0.1  0.05 0.7420463
#
#  URL: http://psychstat.org/regression

#To generate a power curve given a sequence of sample sizes:
res <- wp.regression(n = seq(50,300,50), p1 = 3, f2 = 0.1, 
                                 alpha = 0.05, power = NULL)
res
#  Power for multiple regression
#
#      n p1 p2  f2 alpha     power
#    50  3  0 0.1  0.05 0.4077879
#    100  3  0 0.1  0.05 0.7420463
#    150  3  0 0.1  0.05 0.9092082
#    200  3  0 0.1  0.05 0.9724593
#    250  3  0 0.1  0.05 0.9925216
#    300  3  0 0.1  0.05 0.9981375
#
#  URL: http://psychstat.org/regression

#To plot the power curve:
plot(res) 

#To calculate the required sample size given power and effect size:
wp.regression(n = NULL, p1 = 3, f2 = 0.1, alpha = 0.05, power = 0.8)
#  Power for multiple regression
#
#           n p1 p2  f2 alpha power
#    113.0103  3  0 0.1  0.05   0.8
#
#  URL: http://psychstat.org/regression

#The statistical power given sample size and effect size when controling two predictors:
wp.regression(n = 100, p1 = 3, p2 = 2, f2 = 0.1429, alpha = 0.05, power = NULL)
#  Power for multiple regression
#
#      n p1 p2     f2 alpha     power
#    100  3  2 0.1429  0.05 0.9594695
#
#  URL: http://psychstat.org/regression

# To generate a power curve given a sequence of effect sizes:
res <- wp.regression(n = 50, p1 = 3, f2 = seq(0.05,0.5,0.05),
                                  alpha = 0.05, power = NULL)
res
#  Power for multiple regression
#
#     n p1 p2   f2 alpha     power
#    50  3  0 0.05  0.05 0.2164842
#    50  3  0 0.10  0.05 0.4077879
#    50  3  0 0.15  0.05 0.5821296
#    50  3  0 0.20  0.05 0.7210141
#    50  3  0 0.25  0.05 0.8220164
#    50  3  0 0.30  0.05 0.8906954
#    50  3  0 0.35  0.05 0.9350154
#    50  3  0 0.40  0.05 0.9624324
#    50  3  0 0.45  0.05 0.9788077
#    50  3  0 0.50  0.05 0.9883012
#
#  URL: http://psychstat.org/regression

}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed). Hillsdale, NJ: Lawrence Erlbaum Associates.

Maxwell, S. E., & Delaney, H. D. (2004). Designing experiments and analyzing data: A model comparison perspective (Vol. 1). Psychology Press.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
