% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharing.R
\name{arc_item_data}
\alias{arc_item_data}
\title{Download an Item's Data}
\usage{
arc_item_data(item, host = arc_host(), token = arc_token())
}
\arguments{
\item{item}{the item ID or the result of \code{arc_item()}.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
a raw vector containing the bytes of the data associated with the item. If the response is \code{application/json} then the json string is returned without parsing.
}
\description{
Download the data backing a portal item. This function always returns
a raw vector as the type of the data that is downloaded cannot always be known.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
arc_item_data("9df5e769bfe8412b8de36a2e618c7672")
\dontshow{\}) # examplesIf}
}
\seealso{
Other portal item: 
\code{\link{arc_item}()}
}
\concept{portal item}
