% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviBartPlot.R
\name{viviBartPlot}
\alias{viviBartPlot}
\title{viviBartPlot}
\usage{
viviBartPlot(
  matrix,
  intPal = NULL,
  impPal = NULL,
  intLims = NULL,
  impLims = NULL,
  uncIntLims = NULL,
  uncImpLims = NULL,
  unc_levels = 4,
  max_desat = 0.6,
  pow_desat = 0.2,
  max_light = 0.6,
  pow_light = 1,
  angle = 0,
  border = FALSE,
  label = NULL
)
}
\arguments{
\item{matrix}{Matrices, such as that returned by viviBartMatrix, of values to be plotted.}

\item{intPal}{A vector of colours to show interactions, for use with scale_fill_gradientn. Palette number has to be 2^x/2}

\item{impPal}{A vector of colours to show importance, for use with scale_fill_gradientn. Palette number has to be 2^x/2}

\item{intLims}{Specifies the fit range for the color map for interaction strength.}

\item{impLims}{Specifies the fit range for the color map for importance.}

\item{uncIntLims}{Specifies the fit range for the color map for interaction strength uncertainties.}

\item{uncImpLims}{Specifies the fit range for the color map for importance uncertainties.}

\item{unc_levels}{The number of uncertainty levels}

\item{max_desat}{The maximum desaturation level.}

\item{pow_desat}{The power of desaturation level.}

\item{max_light}{The maximum light level.}

\item{pow_light}{The power of light level.}

\item{angle}{The angle to rotate the x-axis labels. Defaults to zero.}

\item{border}{Logical. If TRUE then draw a black border around the diagonal elements.}

\item{label}{legend label for the uncertainty measure.}
}
\value{
Either a heatmap, VSUP, or quantile heatmap plot.
}
\description{
Plots a Heatmap showing variable importance on the diagonal
and variable interaction on the off-diagonal with uncertainty included.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)

 # VSUP Matrix
 vsupMat <- viviBartMatrix(trees = trees_data,
                           type = 'vsup',
                           metric = 'propMean',
                           metricError = 'CV')
 # Plot
 viviBartPlot(vsupMat, label = 'CV')
 }


}
