% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_r2.R
\name{score_r2}
\alias{score_r2}
\title{Compute R-squared between numeric observations and predictions}
\usage{
score_r2(o = NULL, p = NULL, ...)
}
\arguments{
\item{o}{(required, numeric vector) Observations. Default: NULL}

\item{p}{(required, numeric vector) Predictions. Default: NULL}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
numeric: Pearson R-squared
}
\description{
Internal function to compute the R-squared of observations versus predictions via \code{stats::cor()}. Used within \code{\link[=f_numeric_glm]{f_numeric_glm()}}, \code{\link[=f_numeric_gam]{f_numeric_gam()}}, \code{\link[=f_numeric_rf]{f_numeric_rf()}}, \code{\link[=f_count_glm]{f_count_glm()}}, and \code{\link[=f_count_gam]{f_count_gam()}}.
}
\examples{
  score_r2(
    o = c(1, 1, 1, 0.5, 0.5, 0, 0),
    p = c(1, 0.8, 0.7, 0.6, 0.5, 0.1, 0)
  )
}
\seealso{
Other modelling_tools: 
\code{\link{case_weights}()},
\code{\link{model_formula}()},
\code{\link{score_auc}()},
\code{\link{score_cramer}()}
}
\concept{modelling_tools}
