% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_traits_by_point.R
\name{summarize_traits_by_point}
\alias{summarize_traits_by_point}
\title{Summarize trait distributions at sampling points with optional continent assignment}
\usage{
summarize_traits_by_point(
  points_df,
  trait_df,
  species_polygons,
  comm_metric_1 = function(x) mean(x, na.rm = TRUE),
  comm_metric_2 = function(x) sd(x, na.rm = TRUE),
  trait_column = "trait_name",
  species_name_col = "sci_name",
  continent = FALSE,
  lon_col = "Longitude",
  lat_col = "Latitude",
  parallel = TRUE,
  n_cores = parallel::detectCores() - 1
)
}
\arguments{
\item{points_df}{A data frame containing sampling points with columns for longitude and latitude.}

\item{trait_df}{A data frame of trait data. Must include a column for species names ('TaxonName')
and the trait of interest (default = "trait_name").}

\item{species_polygons}{An \code{sf} object containing species distribution polygons. Must include a species name column.}

\item{comm_metric_1}{A function used to summarize the trait values across overlapping species.
Defaults to \code{mean(x, na.rm = TRUE)}. The function must take a numeric vector as input and return a single numeric value.
Can be replaced by any user-defined function, such as \code{max}, \code{median}, or a custom function.}

\item{comm_metric_2}{A second function used to summarize trait values.
Defaults to \code{sd(x, na.rm = TRUE)}. Works the same way as \code{summary_trait_1}.}

\item{trait_column}{The name of the trait column in \code{trait_df} to summarize.}

\item{species_name_col}{The name of the column in \code{species_polygons} that contains species names (default = "sci_name").}

\item{continent}{Logical. If \code{TRUE}, assigns each sampling point to a continent using the Natural Earth shapefile via \code{rnaturalearth::ne_countries()}. If \code{FALSE} (default), no continent assignment is performed.}

\item{lon_col}{Name of the longitude column in \code{points_df}. Default is 'Longitude'.}

\item{lat_col}{Name of the latitude column in \code{points_df}. Default is 'Latitude'.}

\item{parallel}{Logical; whether to parallelize the summarization step (default TRUE).}

\item{n_cores}{Number of cores to use if parallelizing (default: detectCores() - 1).}
}
\value{
A list with two elements:
\describe{
\item{points}{A data frame identical to \code{points_df} but with additional columns:
\describe{
\item{summ_trait_1}{Result of applying \code{metric_1} to the trait values of overlapping species (e.g., mean, max, median).}
\item{summ_trait_2}{Result of applying \code{metric_2} to the trait values of overlapping species (e.g., standard deviation, range).}
\item{richness}{Number of species overlapping the point (regardless of trait availability).}
\item{count_trait}{Number of species with non-missing trait values at the point.}
\item{continent}{(Optional) Continent name assigned from Natural Earth data, if \code{continent = TRUE}.}
}
}
\item{overlap}{A list of character vectors, each containing the names of species whose distribution polygons overlap a given sampling point.}
}
}
\description{
For each spatial sampling point, this function calculates two metrics specified
by the user of a trait across all overlapping species polygons, and calculates richness.
Optionally, it assigns each point to a continent using Natural Earth data.
}
\examples{
\donttest{
# Load sample data from the package
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")

traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

head(traitsByPoint$points)
}

}
