% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_nns.R
\name{permute_contrast}
\alias{permute_contrast}
\title{Permute similarity and ratio computations}
\usage{
permute_contrast(
  target_embeddings1 = NULL,
  target_embeddings2 = NULL,
  pre_trained = NULL,
  candidates = NULL,
  norm = NULL
)
}
\arguments{
\item{target_embeddings1}{ALC embeddings for group 1}

\item{target_embeddings2}{ALC embeddings for group 2}

\item{pre_trained}{a V x D matrix of numeric values - pretrained embeddings with V = size of vocabulary and D = embedding dimensions}

\item{candidates}{character vector defining the candidates for nearest neighbors - e.g. output from \code{get_local_vocab}}

\item{norm}{character = c("l2", "none") - set to 'l2' for cosine similarity and to 'none' for inner product (see ?sim2 in text2vec)}
}
\value{
a list with three elements, nns for group 1, nns for group 2 and nns_ratio comparing with ratios of similarities between the two groups
}
\description{
Permute similarity and ratio computations
}
