% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_nns.R
\name{bootstrap_nns}
\alias{bootstrap_nns}
\title{Bootstrap nearest neighbors}
\usage{
bootstrap_nns(
  context = NULL,
  pre_trained = NULL,
  transform = TRUE,
  transform_matrix = NULL,
  candidates = NULL,
  bootstrap = TRUE,
  num_bootstraps = 100,
  confidence_level = 0.95,
  N = 50,
  norm = "l2"
)
}
\arguments{
\item{context}{(character) vector of texts - \code{context} variable in get_context output}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform}{(logical) - if TRUE (default) apply the a la carte transformation, if FALSE ouput untransformed averaged embedding.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{candidates}{(character) vector defining the candidates for nearest neighbors - e.g. output from \code{get_local_vocab}.}

\item{bootstrap}{(logical) if TRUE, bootstrap similarity values - sample from texts with replacement.
Required to get std. errors.}

\item{num_bootstraps}{(numeric) - number of bootstraps to use.}

\item{confidence_level}{(numeric in (0,1)) confidence level e.g. 0.95}

\item{N}{(numeric) number of nearest neighbors to return.}

\item{norm}{(character) - how to compute the similarity (see ?text2vec::sim2):
\describe{
\item{\code{"l2"}}{cosine similarity}
\item{\code{"none"}}{inner product}
}}
}
\value{
a \code{data.frame} with the following columns:
\describe{
\item{\code{feature}}{(character)  vector of feature terms corresponding to the nearest neighbors.}
\item{\code{value}}{(numeric) cosine/inner product similarity between
texts and feature. Average over bootstrapped samples if bootstrap = TRUE.}
\item{\code{std.error}}{(numeric) std. error of the similarity value. Column is dropped if bootstrap = FALSE.}
\item{\code{lower.ci}}{(numeric) (if bootstrap = TRUE) lower bound of the confidence interval.}
\item{\code{upper.ci}}{(numeric) (if bootstrap = TRUE) upper bound of the confidence interval.}
}
}
\description{
Uses bootstrapping --sampling of of texts with replacement--
to identify the top N nearest neighbors based on cosine or inner product
similarity.
}
\examples{

# find contexts of immigration
context_immigration <- get_context(x = cr_sample_corpus,
                                   target = 'immigration',
                                   window = 6,
                                   valuetype = "fixed",
                                   case_insensitive = TRUE,
                                   hard_cut = FALSE, verbose = FALSE)

# find local vocab (use it to define the candidate of nearest neighbors)
local_vocab <- get_local_vocab(context_immigration$context, pre_trained = cr_glove_subset)

set.seed(42L)
nns_immigration <- bootstrap_nns(context = context_immigration$context,
                                 pre_trained = cr_glove_subset,
                                 transform_matrix = cr_transform,
                                 transform = TRUE,
                                 candidates = local_vocab,
                                 bootstrap = TRUE,
                                 num_bootstraps = 100,
                                 confidence_level = 0.95,
                                 N = 50,
                                 norm = "l2")

head(nns_immigration)

}
\keyword{bootstrap_nns}
