% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_context.R
\name{tokens_context}
\alias{tokens_context}
\title{Get the tokens of contexts sorrounding user defined patterns}
\usage{
tokens_context(
  x,
  pattern,
  window = 6L,
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE,
  hard_cut = FALSE,
  rm_keyword = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{a (quanteda) \code{tokens-class} object}

\item{pattern}{a character vector, list of character vectors, \link[quanteda]{dictionary},
or collocations object.  See \link[quanteda]{pattern} for details.}

\item{window}{the number of context words to be displayed around the keyword}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link[quanteda]{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link[quanteda]{dictionary} values}

\item{hard_cut}{(logical) - if TRUE then a context must have \code{window} x 2 tokens,
if FALSE it can have \code{window} x 2 or fewer (e.g. if a doc begins with a target word,
then context will have \code{window} tokens rather than \code{window} x 2)}

\item{rm_keyword}{(logical) if FALSE, keyword matching pattern is included in the tokenized contexts}

\item{verbose}{(logical) if TRUE, report the total number of instances per pattern found}
}
\value{
a (quanteda) \code{tokens-class}. Each document in the output tokens object
inherits the document variables (\code{docvars}) of the document from whence it came,
along with a column registering corresponding the pattern used.
This information can be retrieved using \code{docvars()}.
}
\description{
This function uses quanteda's \code{kwic()} function to find the contexts
around user defined patterns (i.e. target words/phrases) and return a tokens object
with the tokenized contexts and corresponding document variables.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*", window = 6L)
}
\keyword{tokens_context}
