% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioactivity-APIs.R
\name{get_bioactivity_summary}
\alias{get_bioactivity_summary}
\title{Retrieve bioactivity summary for AEID}
\usage{
get_bioactivity_summary(
  AEID = NULL,
  API_key = NULL,
  Server = bioactivity_api_server,
  verbose = FALSE
)
}
\arguments{
\item{AEID}{The assay endpoint indentifier AEID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing summary information corresponding to the
input AEID
}
\description{
Retrieve bioactivity summary for AEID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull an assay bioactivity summary
aeid_1386 <- get_bioactivity_summary(AEID = 1386)
\dontshow{\}) # examplesIf}
}
