% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_basic_stats_obs}
\alias{calc_basic_stats_obs}
\alias{calc_basic_stats_pred}
\title{Calculate Basic Mean, Standard Deviations, and Percentages for Observed and
Predicted Data}
\usage{
calc_basic_stats_obs(rts_u, rts_l, one_cond)

calc_basic_stats_pred(
  pdf_u,
  pdf_l,
  one_cond,
  t_vec,
  dt,
  skip_if_contr_low = NULL
)
}
\arguments{
\item{rts_u, rts_l}{numeric, vectors of response times for the upper and lower
boundaries.}

\item{one_cond}{character, a label for the condition.}

\item{pdf_u, pdf_l}{numeric, vectors of probability density values for the
upper and lower boundaries.}

\item{t_vec}{numeric vector, containing the time points corresponding to the
probability density values.}

\item{dt}{a single numeric, providing the step size in \code{t_vec}.}

\item{skip_if_contr_low}{a single numeric, threshold below which probability
densities are ignored (default is obtained from
\code{\link[=drift_dm_skip_if_contr_low]{drift_dm_skip_if_contr_low()}}).}
}
\value{
A \link{data.frame} with columns:
\itemize{
\item \code{Cond}: Condition label.
\item \code{Mean_U}: Mean response time for the upper boundary
\item \code{Mean_L}: Mean response time for the lower boundary
\item \code{SD_U}: Mean response time for the upper boundary
\item \code{SD_L}: Mean response time for the lower boundary
\item \code{P_U}: Proportion of upper-boundary responses.
}
}
\description{
Backend functions to compute the mean response times, standard deviations of
response times, and response proportions; for both observed RTs or the
predicted probability density functions.
}
\details{
\itemize{
\item For observed data, calculates mean RTs, standard deviations of RTs, and
the proportion of upper responses.
\item The same statistics are calculated for the probability density values (via
simple numerical integration)
}
}
\keyword{internal}
