% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_fit_stats}
\alias{calc_fit_stats}
\title{Calculate Fit Statistics}
\usage{
calc_fit_stats(drift_dm_obj, k = 2, ...)
}
\arguments{
\item{drift_dm_obj}{an object of type \link{drift_dm}}

\item{k}{a single numeric, scaling the penality of \link[stats:AIC]{stats::AIC})}

\item{...}{additional arguments passed forward. Options are \code{probs}, \code{n_bins},
and \code{weight_err} for calculating the RMSE.}
}
\value{
A custom object of class \code{stats_dm}
(c("fit_stats", "stats_dm", "data.frame")). The columns are:
\itemize{
\item \code{Log_Like}: the log-likelihood value
\item \code{Neg_Log_Like}: the negative log-likelihood value
\item \code{AIC}: the calculated AIC value
\item \code{BIC}: the calculated BIC value
\item \code{RMSE_s}: the root-mean-squared error (for RTs in seconds)
\item \code{RMSE_ms}: the root-mean-squared error (for RTs in milliseconds)
If a respective statistic cannot be calculated, the respective column
contains \code{NA}.
}
}
\description{
Computes/Summarizes multiple fit statistics, inclduing Log-Likelihood,
the Negative Log-Likelihood, the Akaike Information Criterion (AIC), the
Bayesian Information Criterion (BIC), and the Root-Mean Squared-Error (RMSE)
statistic.
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}, \link{logLik.drift_dm}
}
\keyword{internal}
