% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\name{archive}
\alias{archive}
\alias{archive,D1Node-method}
\title{Archive an object on a Member Node or Coordinating Node, which hides it from casual searches.}
\usage{
archive(x, ...)

\S4method{archive}{D1Node}(x, pid)
}
\arguments{
\item{x}{The MNode or CNode instance on which the object will be created}

\item{...}{(Not yet used)}

\item{pid}{The identifier of the object to be created}
}
\value{
The pid that was archived if successful, otherwise NULL
}
\description{
This method provides the ability to archive a data or metadata object on the Member Node
provided in the \code{'mnode'} parameter.  Archiving removes the object from DataONE search functions,
thereby making it more difficult to find without completely removing the object.  Archive is intended
for objects that should not be used by current researchers, but for which there is a desire to maintain
a historical record, such as when journal articles might cite the object.  Users can still obtain the
contents of archived objects if they have the identifier, but will not discover it through searches.
}
\details{
Methods that perform write operations (such as createObject and updateObject) on the MN generally
require authentication. For MNs that have implemented the DataONE API version 2.0 and higher, these operations can utilize an
authentication token to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your account profile on https://search.dataone.org).
See the \code{vignette("v01-dataone-overview")} for details.
Also, administrator privilege is required to run archive() on a DataONE Coordinating Node.
}
\examples{
\dontrun{
library(dataone)
library(uuid)
library(digest)
library(datapack)
# First create a new object
cn <- CNode("STAGING")
mn <- getMNode(cn, "urn:node:mnStageUCSB2")
testdf <- data.frame(x=1:10,y=11:20)
csvfile <- paste(tempfile(), ".csv", sep="")
write.csv(testdf, csvfile, row.names=FALSE)
\dontrun{
newid <- generateIdentifier(mn, "UUID")
}
# Create an identifier manually
newid <- paste("urn:uuid:", UUIDgenerate(), sep="") 
format <- "text/csv"
size <- file.info(csvfile)$size
sha256 <- digest(csvfile, algo="sha256", serialize=FALSE, file=TRUE)
sysmeta <- new("SystemMetadata", identifier=newid, formatId=format, size=size, checksum=sha256)
sysmeta <- addAccessRule(sysmeta, "public", "read")
# Create (upload) the object to DataONE (requires authentication)
\dontrun{
create(mn, newid, csvfile, sysmeta)
# Now for demonstration purposes, archive the object
# Archive the object (requires authentication)
archivedId <- archive(mn, newid)
}
}
}
\seealso{
\code{\link[=D1Node-class]{D1Node()}} class description.
}
