% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbWebForms.R
\name{createFetchParamsFunction}
\alias{createFetchParamsFunction}
\title{Based on the columns in a table, produces a R function that returns a data.table of HTTP parameters extracted from a list of HTPP params. You can create such a list easily using serverUtils::paramList.}
\usage{
createFetchParamsFunction(
  filepath,
  function_name,
  x,
  id_col,
  type_col,
  exclude = c()
)
}
\arguments{
\item{filepath}{A string, the file path including the name and file type extension where the output will be written.}

\item{function_name}{A string, the name of the function to be written to the file path.}

\item{x}{A data.table, should have a column of input ids (used for input names as well), and a column of HTML input types.}

\item{id_col}{A string, the column of x containing the HTML input ids.}

\item{type_col}{A string, the column of x containing the HTML input types.}

\item{exclude}{A character vector, ids included here will not be included as parameters for the resultant function.}
}
\value{
A data.table, the HTML input type and attributes likely associated with the SQL data type.
}
\description{
Based on the columns in a table, produces a R function that returns a data.table of HTTP parameters extracted from a list of HTPP params. You can create such a list easily using serverUtils::paramList.
}
\examples{
createFetchParamsFunction(
filepath = paste0(tempdir(), "/", "testHTMLFormFunction.R"),
function_name = "fetch_example_function",
x = as.data.table(
list(
ids = c("user_id", "user_name", "first_name", "last_name", "state"),
types = c("number", "text", "text", "text", "text")
)
),
id_col = "ids",
type_col = "types",
exclude = c("user_id")
)
}
