% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/patch.R
\name{patch_make}
\alias{patch_make}
\alias{patch_apply}
\alias{patch}
\title{Create and apply patches to a text string}
\usage{
patch_make(x, y)

patch_apply(x, patch)
}
\arguments{
\item{x}{The source string}

\item{y}{The destination string}

\item{patch}{A string representation of the patch(es).}
}
\value{
\code{patch_make()} returns a string representation of the patch(es).

\itemize{
\item \code{patch_apply()} returns the patched version of the string \code{x},
the \code{matches} attribute contains logical values indicating which patches
were successfully applied.
}
}
\description{
Patches are constructed via \code{patch_make()} and applied using \code{patch_apply()}.
}
\examples{

(p = patch_make("abcdef", "abchij"))

patch_apply("abcdef", p)

patch_apply("abc", p)

patch_apply("def", p)

patch_apply("hij", p)

}
