% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1Dplots.R
\name{plot_QQplot}
\alias{plot_QQplot}
\title{QQplot of GMM decomposition for 1D data}
\usage{
plot_QQplot(X, alpha, mu, sigma)
}
\arguments{
\item{X}{Vector of 1D data for GMM decomposition.}

\item{alpha}{Vector containing the weights (alpha) for each component in the statistical model.}

\item{mu}{Vector containing the means (mu) for each component in the statistical model}

\item{sigma}{Vector containing the standard deviation (sigma) for each component in the statistical model.}
}
\value{
An object extending \code{ggplot} that arranges two quantile-quantile
plots into a single figure. One panel shows a QQ plot of the input
data against a normal distribution, and the other shows a QQ plot
against data simulated from the fitted Gaussian mixture model.
}
\description{
Function return ggplot object with fit diagnostic Quantile-Quantile plot for one normal distribution and fitted GMM.
This plot is also return as regular output of \code{\link{runGMM}}.
}
\examples{
data(example)

alpha <- c(0.45, 0.5, 0.05)
mu <- c(-14, -2, 5)
sigma <- c(2, 4, 1.5)

plot_QQplot(example$Dist, alpha, mu, sigma)

}
\seealso{
\code{\link{runGMM}}
}
