% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.unique.R
\name{ds.unique}
\alias{ds.unique}
\title{Perform 'unique' on a variable on the server-side}
\usage{
ds.unique(x.name = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{x.name}{a character string providing the name of the variable, in the server, to perform \code{unique} upon}

\item{newobj}{a character string that provides the name for the output object
that is stored on the data servers. Default \code{unique.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.unique} returns the vector of unique R objects which are written to the server-side.
}
\description{
Perform 'unique', from the 'base' package on a specified variable on the server-side
}
\details{
Will create a vector or list which has no duplicate values.

Server function called: \code{uniqueDS}
}
\examples{
\dontrun{
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1",
                 url = "http://192.168.56.100:8080/",
                 user = "administrator", password = "datashield_test&",
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2",
                 url = "http://192.168.56.100:8080/",
                 user = "administrator", password = "datashield_test&",
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/",
                 user = "administrator", password = "datashield_test&",
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()

  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D")

  # Create a vector with combined objects
  ds.unique(x.name = "D$LAB_TSC", newobj = "new.vect", datasources = connections)

  # Clear the Datashield R sessions and logout
  datashield.logout(connections)
}
}
\author{
Stuart Wheater, DataSHIELD Development Team
}
