% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxPlotGGDS.R
\name{boxPlotGGDS}
\alias{boxPlotGGDS}
\title{Create the identity stats and necessary data to draw a plot on the client}
\usage{
boxPlotGGDS(data_table, group = NULL, group2 = NULL)
}
\arguments{
\item{data_table}{\code{data frame} Table that holds the information to be plotted, arranged as: \cr

 Column 'x': Names on the X axis of the boxplot, aka variables to plot \cr
 Column 'value': Values for that variable (raw data of columns rbinded) \cr
 Column 'group': (Optional) Values of the grouping variable \cr
 Column 'group2': (Optional) Values of the second grouping variable \cr}

\item{group}{\code{character} (default \code{NULL}) Name of the first grouping variable.}

\item{group2}{\code{character} (default \code{NULL}) Name of the second grouping variable.}
}
\value{
\code{list} with: \cr
-\code{data frame} Geometrical parameters (identity stats of ggplot) \cr
-\code{character} Type of plot (single_group, double_group or no_group) \cr
}
\description{
In order to create a non disclosive box plot, the data that is passed to the client
is purely geometrical aspects of the plot, as a ggplot object contains all the data inside, only the graphical
parameters are passed. There are three different cases depending if there are grouping variables. 
The outliers are also removed from the graphical parameters.
}
