% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetDS.R
\name{subsetDS}
\alias{subsetDS}
\title{Generates a valid subset of a table or a vector}
\usage{
subsetDS(
  dt = NULL,
  complt = NULL,
  rs = NULL,
  cs = NULL,
  lg = NULL,
  th = NULL,
  varname = NULL
)
}
\arguments{
\item{dt}{a string character, the name of the dataframe or the factor vector and the range of the subset.}

\item{complt}{a boolean that tells if the subset to subset should include only complete cases}

\item{rs}{a vector of two integers that give the range of rows de extract.}

\item{cs}{a vector of two integers or one or more characters; the indices of the columns to extract or the names of the columns (i.e. 
names of the variables to extract).}

\item{lg}{a character, the logical parameter to use if the user wishes to subset a vector using a logical 
operator. This parameter is ignored if the input data is not a vector.}

\item{th}{a numeric, the threshold to use in conjunction with the logical parameter. This parameter is ignored 
if the input data is not a vector.}

\item{varname}{a character, if the input data is a table, if this parameter is provided along with the 'logical' and 'threshold'
parameters, a subtable is based the threshold applied to the specified variable. This parameter is however ignored if the parameter
'rows' and/or 'cols' are provided.}
}
\value{
a subset of the vector, matrix or dataframe as specified is stored on the server side
}
\description{
The function uses the R classical subsetting with squared brackets '[]' and allows also to 
subset using a logical operator and a threshold. The object to subset from must be a vector (factor, numeric 
or character) or a table (data.frame or matrix).
}
\details{
If the input data is a table: The user specifies the rows and/or columns to include in the subset if the input 
object is a table; the columns can be referred to by their names. The name of a vector (i.e. a variable) can also be provided 
with a logical operator and a threshold (see example 3). 
If the input data is a vector:  when the parameters 'rows', 'logical' and 'threshold' are all provided the last two are ignored (
'rows' has precedence over the other two parameters then).
If the requested subset is not valid (i.e. contains less than the allowed
number of observations), the subset is not generated, rather a table or a vector of missing values is generated to allow
for any subsequent process using the output of the function to proceed after informing the user via a message.
}
\author{
Gaye, A.
}
